/*** 1.   ũƮ ***/

SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS userid
	, NEWID() AS txt
	, DATEADD(dd,a.number,'2020-01-01') AS date 
INTO TB_OR
FROM master..spt_values a, master..spt_values b
WHERE a.type = 'P'
AND b.type = 'P'
AND a.number BETWEEN 1 AND 1000
AND b.number BETWEEN 1 AND 1000

CREATE INDEX NIDX01_OR on TB_OR (userid)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

DECLARE @userid INT = 555
SELECT COUNT(*)
FROM TB_OR
WHERE (@userid IS NULL) 
	OR (@userid IS NOT NULL AND userid = @userid)
GO


/*** 6. [TO-BE]   ***/

DECLARE @userid INT = 555
SELECT SUM(cnt) cnt
FROM (SELECT COUNT(*) cnt
	 FROM TB_OR
	 WHERE ( @userid IS NULL) 
	 UNION ALL
	 SELECT COUNT(*) cnt
	 FROM TB_OR
	 WHERE ( @userid IS NOT NULL AND userid = @userid) 
) a
GO